//	Persistence of Vision Ray Tracer Scene Description File

//do at 480x640 for Swine cover
//with anti-aliasing 2 threshold .3 recursion 2 jitter .5
//no alpha

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"

//#version unofficial MegaPov 1.0;
camera {
	perspective 
	location <0.0, 3.0, -8>
	look_at <0.0, 1.5, 0.0>

	right x*image_width/image_height
}

light_source {
	<6, 20, -100>
	rgb <1.0, 1.0, 1.0>
}


sky_sphere {
	pigment  {
		gradient x
		turbulence .3
		color_map {
			[0.000 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 1
			[0.100 color rgbft <1.0, 0.5, 1.0, 0.0, 0.0 > ]	//violet 2
			[0.214 color rgbft <0.5, 0.5, 1.0, 0.0, 0.0 > ]	//indigo
			[0.328 color rgbft <0.2, 0.2, 1.0, 0.0, 0.0 > ]	//blue
			[0.442 color rgbft <0.2, 1.0, 1.0, 0.0, 0.0 > ]	//cyan
			[0.556 color rgbft <0.2, 1.0, 0.2, 0.0, 0.0 > ]	//green
			[0.670 color rgbft <1.0, 1.0, 0.2, 0.0, 0.0 > ]	//yellow
			[0.784 color rgbft <1.0, 0.5, 0.2, 0.0, 0.0 > ]	//orange
			[0.900 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red1
			[1.000 color rgbft <1.0, 0.2, 0.2, 0.0, 0.0 > ]	//red2
		}
		scale .2
	}
}

background {
	color White
}

#declare pipe_width = 0.25;
#declare nozzle_shift_width = pipe_width*.8;
#declare cone_bottom = 0;
#declare cone_top = cone_bottom + .8;
#declare nozzle_shift_bottom  = cone_bottom - .1;
#declare nozzle_bottom = nozzle_shift_bottom - .8;
#declare cone_hole_height = cone_top - .15;
#declare cone_teeth_height = cone_top - .01;


#declare pipe_t = texture {
	pigment {
		color Green
	}
	finish {
		ambient .3
	}
	normal {
		bumps .8
		scale .01
	}
}

#declare joint_t = texture {
	pigment {
		color Gray
	}
	finish {
		metallic
		reflection .3
	}
}

#declare entry_cone = 	cone {
		<0, cone_bottom, 0>, pipe_width,
		<0, cone_top, 0>, pipe_width*3
}
#declare cone_nozzle = union {
	cone {
		<0, nozzle_shift_bottom, 0>, nozzle_shift_width
		<0, cone_bottom, 0>, pipe_width
	}
	cone {
		<0, nozzle_bottom, 0>, pipe_width*.25
		<0, nozzle_shift_bottom, 0>, nozzle_shift_width
	}
}

#declare cone_hole = 	cylinder {
	<-pipe_width*3.1, cone_hole_height, 0>
	<pipe_width*3.1, cone_hole_height, 0>
	pipe_width/3
}
#declare cone_teeth = 	cylinder {
	<-pipe_width*3.1, cone_teeth_height, 0>
	<pipe_width*3.1, cone_teeth_height, 0>
	pipe_width/3
}

#declare v_pipe = difference {
	cylinder {
		<0, 0, 0>
		<0, 1, 0>
		pipe_width
	}
	cylinder {
		<0, -.01, 0>
		<0, 1.01, 0>
		pipe_width * .99
	}
}

#declare h_pipe = object { v_pipe
	rotate <0, 0, -90>
}
#declare z_pipe = object { h_pipe
	rotate <0, -90,0>
}

#declare p_joint = superellipsoid {
	< 0.2, 0.2 >
	scale pipe_width*1.2
	texture { joint_t }
}

union {
	difference {
		union {
			object { entry_cone }
			object { cone_nozzle }
		}
		object { entry_cone
			scale .9
			translate <0, .15, 0>
		}
		#declare pipe_count = 12;
		#declare current_pipe = 1;
		#while (current_pipe <= pipe_count)
			object { cone_hole
				rotate <0, current_pipe*360/pipe_count, 0>
			}
			#declare current_pipe = current_pipe + 1;
		#end
		rotate <0, 0, 3>
		translate <0, .2, 0>
		texture { joint_t }
	}

	//pipes
	#declare pipe_y = -1;
	#declare pipe_z = 0;
	#declare pipe_x = 0;
	#declare pipe_length = 2;
	object {	v_pipe
		translate <pipe_x, pipe_y, pipe_z>
		scale <1, pipe_length, 1>
	}
	#declare pipe_y = pipe_y - 1;
	object { p_joint
		translate <0, pipe_y, 0>
	}
	
	#declare pipe_length = 1.5;
	object { h_pipe
		translate <pipe_x, pipe_y, pipe_z>
		scale <pipe_length, 1, 1>
	}
	
	#declare pipe_x = pipe_x + pipe_length;
	object { p_joint
		translate <pipe_x, pipe_y, pipe_z>
	}
	difference {
		object { entry_cone }
		#declare pipe_count = 12;
		#declare current_pipe = 1;
		#while (current_pipe <= pipe_count)
			object { cone_teeth
				rotate <0, current_pipe*360/pipe_count, 0>
			}
			#declare current_pipe = current_pipe + 1;
		#end
		scale <1, -1, 1>
		translate <pipe_x, pipe_y - .3, 0>
	}
	object { h_pipe
		scale <pipe_length, 1, 1>
		translate <pipe_x, pipe_y, 0>
	}
	
	#declare pipe_x = pipe_x + pipe_length;
	object { p_joint
		translate <pipe_x, pipe_y, pipe_z>
	}

	#declare pipe_length = 2;	
	object { z_pipe
		scale <1, 1, pipe_length>
		translate <pipe_x, pipe_y, pipe_z>
	}
	#declare pipe_z = pipe_z + pipe_length;

	object { p_joint
		translate <pipe_x, pipe_y, pipe_z>
	}
	
	torus {
		pipe_x/2, pipe_width
		rotate <90, 0, 0>
		translate <pipe_x/2, pipe_y, pipe_z>
		sturm
	}
	
	#declare pipe_x = pipe_x - pipe_x;
	object { p_joint
		translate <pipe_x, pipe_y, pipe_z>
	}

	#declare pipe_z = pipe_z - pipe_length;
	object { z_pipe
		scale <1, 1, pipe_length>
		translate <pipe_x, pipe_y, pipe_z>
	}
	#declare pipe_z = pipe_z - pipe_length;

	texture { pipe_t }
	translate  <-1.5, 2.5, 0>
}

#declare letterThickness = 0.15;

#declare letterS = text {
	ttf "Geneva.ttf",
	"S"
	letterThickness, <0, 0, 0>
}

#declare letterA = text {
	ttf "Geneva.ttf",
	"A"
	letterThickness, <0.0, 0.0, 0.0>
}

#declare letterU = text {
	ttf "Geneva.ttf",
	"U"
	letterThickness, <0.0, 0.0, 0.0>
}

#declare letterG = text {
	ttf "Geneva.ttf",
	"G"
	letterThickness, <0.0, 0.0, 0.0>
}

#declare letterE = text {
	ttf "Geneva.ttf",
	"E"
	letterThickness, <0.0, 0.0, 0.0>
}

//jumbled text
union {
	object { letterA
		pigment {
		color Red
	}
 }
	object { letterS
		rotate <0, 0, 10>
		translate <1, .5, 0>
		pigment {
			color Blue
		}
	}
	object { letterU
		rotate <0, 0, -12>
		translate <-1, 1, 0>
		pigment {
			color Gold
		}
	}
	object { letterS
		rotate <0, 0, -22>
		translate <.25, 1.62, 0>
		pigment {
			color Violet
		}
	}
	object { letterA
		rotate <0, 0, -30>
		translate <1.5, -.75, 0>
		pigment {
			color Yellow
		}
	}
	object { letterG
		rotate <0, 0, -30>
		translate <-1.05, -.25, 0>
		pigment {
			color Pink
		}
	}
	object { letterE
		rotate <0, 0, 30>
		translate <.75, -.95, 0>
		pigment {
			color Orange
		}
	}

	scale .5
	translate <-2, 4, 0>
}

//unjumbled
text {
	ttf "Geneva.ttf",
	"sausage"
	letterThickness, <0.0, 0.0, 0.0>
	scale .5
	rotate <0, 0, 90>
	translate <0.2, -2, 0>
	pigment {
		color DustyRose
	}
}

#declare bit1 = text {
	ttf "Geneva.ttf",
	"1"
	letterThickness, <0.0, 0.0, 0.0>
}
#declare bit0 = text {
	ttf "Geneva.ttf",
	"0"
	letterThickness, <0.0, 0.0, 0.0>
}

union {
	#declare bitChooser = seed(99);
	#declare bitCount = 38;
	#declare rowCount = 30;
	#declare rowCounter = rowCount;
	#while (rowCounter > 0)
		#declare bits = "";
		#declare bitCounter = bitCount;
		#while (bitCounter > 0)
			#declare bitChoice = rand(bitChooser);
			#if (bitChoice > 0.5)
				#declare bit = "1";
			#else
				#declare bit = "0";
			#end
			#declare bits = concat(bits, bit);
			#declare bitCounter = bitCounter - 1;
		#end
		text {
			ttf "Geneva.ttf",
			bits
			letterThickness, <0, 0, 0>
			translate <-.65*bitCount/2, .75*rowCount/2-rowCounter, 0>
		}
		#declare rowCounter = rowCounter - 1;
	#end
	pigment {
		gradient x
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
	translate <0, 0, -50>
	no_shadow
	
}