//Speech/Sound Cartridge subroutines
//Jerry Stratton, astoundingscripts.com

#expects text in %speech$
sub speakSpeech
	for i=1 to len(%speech$)
		gosub waitForVoice
		poke %soundPort%, asc(mid$(%speech$,i,1))
	next i
	gosub waitForVoice
	#carriage return
	poke %soundPort%, 13
	pause .3
endsub

sub prepareSpeech
	%soundInput% = &HFF00
	%soundPort% = &HFF7E
	%soundReset% = &HFF7D

	#reset cart
	poke %soundReset%, 1
	poke %soundReset%, 0

	//save values to disable cartridge
	//to run a different cartridge on the MPI
	%soundInput1% = peek(%soundInput%+1)
	%soundInput3% = peek(%soundInput%+3)
	%soundInput35% = peek(%soundInput%+35)

	#enable sound multiplexer
	poke %soundInput%+1,52
	poke %soundInput%+3,63
	poke %soundInput%+35,60
endsub

sub disableSpeech
	#disable sound multiplexer
	poke %soundInput%+1, %soundInput1%
	poke %soundInput%+3, %soundInput3%
	poke %soundInput%+35, %soundInput35%
endsub

sub waitForVoice
	loop
		%voiceReady% = peek(%soundPort%) and 128
	endloop unless (%voiceReady% = 0)
endsub

#prepare voice
gosub prepareSpeech
