import ui, photos
import random

class FlashView(ui.View):
	def __init__(self):
		self.currentCard = None

	def draw(self):
		self.frameCard()

	def resetFlasher(self, flasher):
		flasher.x = 6
		flasher.y = 12
		flasher.width = self.width - 12
		flasher.height = self.height - 80

	def frameCard(self):
		card = self.currentCard
		if not card:
			return
		flasher = self['flasher']

		self.resetFlasher(flasher)
		if card.pixel_width/card.pixel_height > flasher.width/flasher.height:
			#need to reduce the height of the flashcard display
			oldHeight = flasher.height
			newHeight = flasher.width*card.pixel_height/card.pixel_width
			flasher.height = newHeight
			flasher.y += (oldHeight-newHeight)/2
		elif card.pixel_width/card.pixel_height < flasher.width/flasher.height:
			#need to reduce the width of the flashcard display
			oldWidth = flasher.width
			newWidth = flasher.height*card.pixel_width/card.pixel_height
			flasher.width = newWidth
			flasher.x += (oldWidth-newWidth)/2

	def newCard(self, flasher, card):
		view.currentCard = card
		flasher.background_image = card.get_ui_image()
		self.frameCard()

def getAlbums():
	albums = {}
	for album in photos.get_albums():
		if 'phrases' in album.title:
			albums[album.title] = album
	return albums

def chooseAlbum(chooser):
	albumDrop.selected_row = 0, albumList.items.index(view['albumChooser'].title)
	albumDrop.hidden = False

class AlbumSelector():
	def tableview_did_select(self, tableview, section, row):
		#highlight the selection
		tableview.reload()
		#change the button text
		view['albumChooser'].title = albumList.items[row]
		#hide the drop-down again
		albumDrop.hidden = True

def showCard(flasher):
	album = albums[view['albumChooser'].title]
	card = random.choice(album.assets)

	#if there are more than one card in this album, make sure we aren't repeating the current card
	if view.currentCard and len(album.assets) > 1:
		while card == view.currentCard:
			card = random.choice(album.assets)
	view.newCard(flasher, card)
	flasher.title = ''

#populate list of albums
albums = getAlbums()

#drop-down for choosing an album
albumList = ui.ListDataSource(sorted(albums.keys()))
albumList.delete_enabled = False
albumDrop = ui.TableView()
albumDrop.delegate = AlbumSelector()
albumDrop.hidden = True

#display app
view = ui.load_view()
view.add_subview(albumDrop)
#set default album as the first one in the list
view['albumChooser'].title = albumList.items[0]
view.present()

#align album list dropdown to button
albumDrop.width = view['albumChooser'].width*1.8
albumDrop.row_height = view['albumChooser'].height
albumDrop.height = albumDrop.row_height*(len(albums))
albumDrop.x = view['albumChooser'].x
albumDrop.y = view['albumChooser'].y - albumDrop.height
albumDrop.border_width = view['albumChooser'].border_width
albumDrop.border_color = view['albumChooser'].border_color
albumDrop.data_source = albumList
albumDrop.reload()
