#include "colors.inc"
//1920x1080 is a good 16:9
//use 24 frames per second
//frames needed for 45 seconds:
//24*45: 1080.000000
#declare videoDuration = 45;

global_settings {
	ambient_light Black
	assumed_gamma 1.0
}

light_source {
	<0, 35, -20>
	color White*.5
}

camera {
	location <0, 0, -10>
	look_at <0,.5,0>
	right x*image_width/image_height
}

//green background
plane {
	z, 0
	pigment {
		color Green
	}
	normal {
		marble turbulence 1
	}
}

//prep the random number streams
#declare locationSeed = seed(1010);
#if (final_frame > 0)
	#declare flashSeedNumber = int(videoDuration*5*frame_number/final_frame);
#else
	#declare flashSeedNumber = 0;
#end

#local flashSeed = seed(flashSeedNumber);
#declare colorSeed = seed(223);

//get a range centered on zero
#macro randomZero(rangeWidth)
	#local zeroBasedLocation = rand(locationSeed)*rangeWidth-rangeWidth/2;
	zeroBasedLocation
#end

//flashing gold and red lights
union {
	#for (i, 0, 124)
		#local lightX = randomZero(20);
		#local lightY = randomZero(14);

		//fifty-fifty chance that a bulb is lit
		#if (rand(flashSeed) > .5)
			#declare bulbIsLit = 1;
			#declare bulbFilter = 1.5;
		#else
			#declare bulbIsLit = 0;
			#declare bulbFilter = 0.8;
		#end

		#local colorChoice = rand(colorSeed);
		#if (colorChoice >  .66)
			#local bulbColor = color Gold;
		#elseif (colorChoice > .33)
			#local bulbColor = color Red;
		#else
			#local bulbColor = color White;
		#end 

		sphere {
			<lightX, lightY, -1>
			.2
			pigment {
				color bulbColor
				filter bulbFilter
			}
			finish {
				#if (bulbIsLit)
					specular albedo 0.9
				#end
				metallic
				reflection {0.5}
			}
		}
	#end

	no_shadow
}
