#!/usr/bin/python
# -*- coding: utf-8 -*-

import scribus
import os

def isBackground(layer):
	if layer.startswith('Background'):
		return True
	return False

#don't do anything unless there's a document open
if scribus.haveDoc():
	#get the folder to save to
	saveTo = scribus.fileDialog('Folder to save characters to:', isdir=True, issave=True)

	if saveTo:
		#deselect, or it will only print the current selection
		scribus.deselectAll()
		layers = scribus.getLayers()
		
		#first, make sure only the background is set to print
		for layer in layers:
			if isBackground(layer):
				scribus.setLayerPrintable(layer, True)
			else:
				scribus.setLayerPrintable(layer, False)

		#now, go through each non-background layer and export as PDF
		exporter = scribus.PDFfile()
		for layer in layers:
			if not isBackground(layer):
				scribus.setLayerPrintable(layer, True)
				filePath = os.path.join(saveTo, layer + u'.pdf')
				exporter.file = str(filePath)
				exporter.save()
				scribus.setLayerPrintable(layer, False)
else:
	scribus.messageBox("No Open Document", "You need to have a document open to save it as PDF.")
