/* produce 'n' random quotes or quote # -n
/* Syntax: quote [n [n...]] [-n [-n...]] */
#include <stdio.h>
#include <errno.h>
#include <time.h>

#define DEFQUOTEFILE "/etc/Quotes\0"
#define PERSQUOTEFOLDER "HOME"
#define PERSQUOTEFILE "/.quotes\0"
#define FALSE 0
#define TRUE 1
#define QUOTESEP '#'
#define QUOTENUMSEP ','

char *getenv();

/* switches */
UseQuoteSep=FALSE;

FILE	*QuotePath; /* path to quote file */
int	QuoteSize; /* size of quote file, in quotes */
char	*CurrentFile="                                             ";
				/* current quote file */

main (argc,argv)
int argc;
char *argv[];

{
	int	argcount=0;
	char	*DefQuoteFile="                                                                  ";

/* seed random number generator */
	srandom(time(NULL));
/* Set up quote file */
	strcpy(DefQuoteFile,getenv(PERSQUOTEFOLDER));
	strcat(DefQuoteFile,PERSQUOTEFILE);
	ChangeQuoteFile(DefQuoteFile,FALSE);
	if (!QuotePath) {
		strcpy(DefQuoteFile,DEFQUOTEFILE);
		ChangeQuoteFile(DefQuoteFile,FALSE);
		if (!QuotePath) {
			ErrorMsg("Default Quote File not found",".");
			exit (0);
		}
	}
	strcpy(CurrentFile,DefQuoteFile);

	while (++argcount < argc)
	{
		if (*argv[argcount]=='-')
			if (*(argv[argcount]+1)=='s')
				DoQuoteSearch(argv[argcount]+2);
			else if (*(argv[argcount]+1)=='f')
				DoQuoteFind(argv[argcount]+2);
			else if (*(argv[argcount]+1)=='q')
				setswitch(*(argv[argcount]+1),*(argv[argcount]+2));
			else if (*(argv[argcount]+1)=='h')
				DoHelp();
			else if (*(argv[argcount]+1)=='H')
				GrepHelp();
			else if (*(argv[argcount]+1)=='c')
				printf("There are %i quotes in %s.\n\n",QuoteSize,CurrentFile);
			else
				DoQuoteNumber(argv[argcount]+1,QuotePath);
		else if (*argv[argcount]<'0' || *argv[argcount]>'9')
			ChangeQuoteFile(argv[argcount],TRUE);
		else DoNQuotes(argv[argcount],QuotePath);
	}
	if (argc==1)
		DoHelp();
	return;
}

DoHelp()
{
	printf("Syntax: quote [n [n...]] [-n [-n...]]\n");
	printf("  'n' produces 'n' random quotes and '-n' produces quote number 'n'.\n");
	printf("  'filename' changes the quote file and -sword looks for that string.\n");
	printf("  -fword looks for that string, but returns the number of the quote.\n");
	("  Quote first looks for a $HOME/.quotes file. It then looks for /etc/Quotes.\n");
	printf("  -c counts the quotes in the current quote file and prints the result.\n");
	printf("  -q[y|n] sets whether or not to include the quote separator %c\n",QUOTESEP);
	printf("  -h prints this help message. -H prints the grep-style search help.\n\n");
}

setswitch(TheSwitch,TheState)
char	TheSwitch;
char	TheState;
{
	switch (TheSwitch) {
		case 'q':
			if (TheState=='n')
				UseQuoteSep=FALSE;
			else UseQuoteSep=TRUE;
		break;
	}
}
DoQuoteNumber(TheNumString)
char *TheNumString;
{
	int	TheNum;

	TheNum=atoi(TheNumString);
	if (TheNum > QuoteSize) {
		ErrorMsg("No quotes as high as ",TheNumString);
		return;
	}
	DoQuote(TheNum);
	return;
}

ErrorMsg(ErrorString,BadString)
char	*ErrorString;
char	*BadString;
{
	printf("%s%s\n",ErrorString,BadString);
	return;
}

DoNQuotes(TheNumString)
char *TheNumString;
{
	int	TheNum;
	long	TheQuote;

	TheNum=atoi(TheNumString);
	while (TheNum-- > 0) {
		TheQuote=(random()%(QuoteSize));
		TheQuote++;
		DoQuote(TheQuote);
	}
	return;
}

ChangeQuoteFile(TheFileName,ShowError)
char	*TheFileName;
int	ShowError;
{
	FILE *ThePath;
	int QuoteCount=0;

	/* check to see if the file exists */
	if (!(ThePath=fopen(TheFileName,"r"))) {
		if (ShowError) {
			ErrorMsg("Bad File Name: ",TheFileName);
		}
	} else {
		while (!feof(ThePath))
			if (fgetc(ThePath)=='\n')
				if (fgetc(ThePath)==QUOTESEP)
					if (fgetc(ThePath)=='\n')
						QuoteCount++;
					else fseek (ThePath,-1,SEEK_CUR);
				else fseek (ThePath,-1,SEEK_CUR);
		if (QuoteCount>0) {
			QuotePath=ThePath;
			QuoteSize=QuoteCount;
			strcpy(CurrentFile,TheFileName);
		} else
			ErrorMsg(TheFileName," is not a quote file.");
	}
}

DoQuote (QuoteNumber)
int	QuoteNumber;
{
	int	StartPos=0;
	int	EndPos=0;

	
	StartPos=fseek (QuotePath,0,SEEK_SET);

	/* count up */
	EndPos=GetNextBreaker();
	while (--QuoteNumber > 0) {
		StartPos=EndPos;
		EndPos=GetNextBreaker();
	}
		

	/* print it out */
	PrintToEnd(StartPos,EndPos);
        printf("\n");
	return;
}

GetNextBreaker()
{
	int	DONE=FALSE;
	int	cur_pos;
	char	testchar;

	while (!feof(QuotePath) && !DONE) {
		if (fgetc(QuotePath)=='\n')
			if (fgetc(QuotePath)==QUOTESEP)
				if (fgetc(QuotePath)=='\n')
					DONE=TRUE;
				else fseek (QuotePath,-1,SEEK_CUR);
			else fseek (QuotePath,-1,SEEK_CUR);
	}
	
	cur_pos=ftell(QuotePath);
	return cur_pos;
}

GetPrevBreaker()
{
	int	StartPos;
	int	DONE=FALSE;

	fseek(QuotePath,-3,SEEK_CUR);
	StartPos=ftell(QuotePath);
	while (StartPos>0 && !DONE) {
		if (fgetc(QuotePath)=='\n') {
			if (fgetc(QuotePath)==QUOTESEP) {
				if (fgetc(QuotePath)=='\n')
					DONE=TRUE;
				fseek(QuotePath,-1,SEEK_CUR);
			}
			fseek(QuotePath,-1,SEEK_CUR);
		}
		fseek(QuotePath,-1,SEEK_CUR);
		fseek(QuotePath,-1,SEEK_CUR);
		StartPos=ftell(QuotePath);
	}
	if (StartPos) {
		StartPos=StartPos+3;
		fseek(QuotePath,3,SEEK_CUR);
	}
	return StartPos;
}

DoQuoteSearch(TheString)
char	*TheString;
{
	int	StartPos,EndPos;

	fseek (QuotePath,0,SEEK_SET);
	grep (QuotePath,TheString);
	while (!feof(QuotePath)) {
		StartPos=GetPrevBreaker();
		EndPos=GetNextBreaker();
		PrintToEnd(StartPos,EndPos);
		grep (QuotePath,TheString);
	}
}

DoQuoteFind(TheString)
char	*TheString;
{
	int	CurrentPos, CurrentQuote;

	fseek(QuotePath,0,SEEK_SET);
	grep (QuotePath,TheString);
	while (!feof(QuotePath)) {
		CurrentPos=ftell(QuotePath);
		fseek(QuotePath,0,SEEK_SET);
		CurrentQuote=0;
		while (ftell(QuotePath)<CurrentPos) {
			GetNextBreaker();
			CurrentQuote++;
		}
		grep (QuotePath,TheString);
		if (feof(QuotePath))
			printf ("%d\n",CurrentQuote);
		else
			printf("%d%c ",CurrentQuote,QUOTENUMSEP);
	}
}

PrintToEnd(Start,End)
int	Start;
int	End;
{
	char	nextchar;
	int	TotalChars;

	fseek(QuotePath,Start,SEEK_SET);
	if (UseQuoteSep)
		TotalChars=End-Start-1;
	else
		TotalChars=End-Start-2;

	while (TotalChars--) {
		nextchar=fgetc(QuotePath);
		fputc(nextchar,stdout);
	}
	return;
}

#include "Libs/grep.c"
