#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <malloc.h>

#define BAD_FILE 1
#define SYNTAX 2
#define TRUE 1
#define FALSE 0


void main(argc,argv)
int argc;
char *argv[];

{
 FILE *TheFile;
 char *FileName;
 int LineLength;
 int re_wrap=FALSE;
 int SynError=FALSE;

 FileName=NULL;

 while (--argc) {
  if (*argv[argc] == '-')
   if (*(argv[argc]+1) == 'r')
    re_wrap = TRUE;
   else SynError=TRUE;
  else if (isdigit(*argv[argc]))
   LineLength=atoi(argv[argc]);
  else FileName=argv[argc];
 }

 if ((SynError || LineLength==0)) {
  ErrorOut(SYNTAX,"No Message");
  exit(0);
 }


 if (!FileName) {
  TheFile=stdin;
 } else if (!(TheFile=fopen(FileName,"r"))) {
  ErrorOut(BAD_FILE,FileName);
  exit(0);
 }

  WrapIt(TheFile,LineLength,re_wrap);
}

WrapIt(TheInput,TheLength,TheWrap)
FILE *TheInput;
int TheLength;
int TheWrap;

{
 char *TheLine,*ThePos;
 char *TheLeftover,*StartLeftover;
 int Count;
 char *EndOfLine;
 int StripSpaces=FALSE;
 char CheckNext,LastChar;

 TheLine=malloc(TheLength+2);
 TheLeftover=malloc(TheLength+2);
 *TheLeftover='\0';
 LastChar='\0';

 while (!feof(TheInput)) {
  ThePos=TheLine;
  Count=0;
  if (*TheLeftover) {
   strcpy(TheLine,TheLeftover);
  ThePos+=strlen(TheLeftover);
  Count=strlen(TheLeftover);
  }
  do {
    *ThePos=fgetc(TheInput);
   if (TheWrap && (*ThePos=='\n')) {
    /* change to a space unless this is a double line */
    CheckNext=fgetc(TheInput);
    if (CheckNext != '\n')
     if (LastChar != '\n')
      *ThePos = ' ';
    ungetc(CheckNext,TheInput);
   }
   while (StripSpaces && (*ThePos==' '))
    *ThePos=fgetc(TheInput);
   StripSpaces=FALSE;
   LastChar= *ThePos;
  } while ((*ThePos++ !='\n') && !feof(TheInput) && (++Count<TheLength));

  if (Count==TheLength) {
  /* check to see if next character is a space */
   CheckNext=fgetc(TheInput);
   if (CheckNext==' ' || CheckNext=='\n')
    Count=0;
   ungetc(CheckNext,TheInput);
  }
  *ThePos='\0';
  EndOfLine=ThePos;

  while ((*(ThePos-1) != '\n') && (*(ThePos-1) != ' ') && Count--)
	ThePos--;

  *TheLeftover='\0';
  if (ThePos==TheLine) {
   ThePos=EndOfLine;
  } else if (EndOfLine!=ThePos) {
   /* save part of line we aren't using this time through */
   StartLeftover=ThePos;
   strcpy(TheLeftover,StartLeftover);
  }

  *ThePos='\0';
  StripSpaces= (*(ThePos-1)!='\n');
  if (!StripSpaces)
   *(ThePos-1)='\0'; 
  printf("%s\n",TheLine);
 }
 free(TheLine);
 free(TheLeftover);
 return;
}

ErrorOut (Why,Message)
int Why;
char *Message;
{
 printf ("Syntax: wrap columns [-r] [filename]\n");
 if (Why==BAD_FILE)
  printf(" Could not get file >%s<.\n",Message);
 else if (Why==SYNTAX) {
  printf(" If no filename is given, wrap uses standard input.\n");
  printf(" Columns is the number of columns to wrap to.\n");
  printf(" If -r is given, 'newlines' will be replaced with 'spaces',\n");
  printf("  effectively re-wrapping the text.\n");
 }
}
