/* alter <char1> [char 2] */
/* Copyright (c) 1990, Jerold M. Stratton */
#include   <stdio.h>
#include   <strings.h>
#include   <errno.h>

#define Syntax 2

char	*strend(char *strptr);
unsigned	htoi(char *hexstr);

void main (argcount,args)
int	argcount;
char	*args[];

{
   int   oldlen;
   int   newlen;
   int   oldtype = 2;
   int   newtype = 2;
   int   new = 2;
   int   old = 1;
   int   delete,newstring;
   char  oldchar = '\0';
   char  newchar = '\0';
   char  InChar;
   char  OutChar;

   char  matchar ();

   if (!--argcount || argcount > 2) {
       ErrorOut(Syntax,"Wrong Number of Arguments");
       exit(0);
   }
   /* check if arg 2 exists */
   delete = (argcount == 1);

   /* check length of each */
   oldlen = strlen(args[old]);

   /* check if length is correct */
   if (oldlen != 1 && oldlen != 2 && oldlen != 3 && oldlen != 8) {
      ErrorOut(Syntax,"Wrong Length for Character Specifications");
      exit(0);
   }  else {
      if (oldlen != 1)
         lower (args[old]);
   }
   if (!delete) {
      newlen = strlen(args[new]);
      newstring = ((*args[new]=='-') && (newlen>1));
      if (!delete && !newstring)  {
         if (newlen != 1 && newlen != 2 && newlen != 3 && newlen != 8) {
            ErrorOut(Syntax,"Invalid Character Specification");
            exit(0);
         } else if (newlen !=1) lower (args[new]);
      }
   }
   if (oldlen != 1) oldtype = valid(args[old],oldlen);
   if (!delete && !newstring && newlen != 1)   {
      newtype = valid(args[new],newlen);
      if ((oldtype==2) && (newtype!=2)) {
         ErrorOut(Syntax,"Wild Replace Character with Fixed Search Character");
         exit(0);
      }
   }
   if (!oldtype || !newtype)   {
      ErrorOut(Syntax,"Invalid Character Specification");
      exit(0);
   }
   if (newstring) ++args[new];
   else if (newtype ==2) {
      switch (newlen)   {
         case (1):
            newchar =  *args[new];
            break;
         case (2):
            newchar = (char) htoi (args[new]);
            break;
         case (3):
            newchar = (char) atoi (args[new]);
            break;
         case (8):
            newchar = (char) btoi (args[new]);
      }
      newlen = 1;
      OutChar =  newchar;
   }
   if (oldtype == 2) {
      switch (oldlen)   {
         case (1):
            oldchar = *args[old];
            break;
         case (2):
            oldchar = (char) htoi (args[old]);
            break;
         case (3):
            oldchar = (char) atoi (args[old]);
            break;   
         case (8):
            oldchar = (char) btoi (args[old]);
      }
      if (newtype == 1)   {
         newchar = matchar(args[new],(int) oldchar,newlen);
         newtype = 2;
         newlen = 1;
         OutChar = newchar;
      }
      oldlen = 1;
   }
	InChar=fgetc(stdin);
	while (!feof(stdin))   {
		if (oldtype == 2)
			if (InChar == oldchar) {
				if (newstring) fputs(args[new],stdout);
				else if (!delete) fputc(OutChar,stdout);
			} else fputc(InChar,stdout);
		else if (check(args[old],(unsigned) InChar,oldlen)) {
			if (newstring) fputs(args[new],stdout);
			else if (!delete)
				if (newtype == 2) fputc(OutChar,stdout);
				else {
				  OutChar=matchar(args[new],(int)InChar,newlen);
				  fputc(OutChar,stdout);
				}
		} else fputc(InChar,stdout);
		InChar=fgetc(stdin);
	}
}
/* this is the end of main */

/* Valid subroutine -- checks to see if types 2,3, and 8 are valid numbers */
/* returns 0 if not valid, 1 if valid with wildcards, and 2 if valid
   without wildcards  */

int   valid (number,type)

char *number;
int   type;

{
   char   *valids = "?0123456789ABCDEFabcdefg";
   char   *valptr;
   char   *pointer;
   int    retval = 2;

/* check to see if valid */
   for (pointer = number; *pointer != 0 && retval; pointer++)  {
      valptr = strchr(valids,*pointer);
      switch (type)   {
         case (2):
            if (*valptr == 0)
               retval = 0;
            break;
         case (3):
            if ((int) (valptr) - (int) (valids) > 10)
               retval = 0;
            break;
         case (8):
            if ((int) (valptr) - (int) (valids) > 2)
               retval = 0;
      }
      if (*pointer == '?')
         retval = 1;
   }
   return (retval);
}

/* end of subroutine valid */

int   btoi (bin)

char  *bin;

{
   char   *bptr;
   int    retval = 0;
   int    badd = 1;
   
   bptr = strend (bin);
   while (bin != bptr--)   {
      if (*bptr == '1')
         retval += badd;
      badd += badd;
   }
   return (retval);
}

/* end of subroutine btoi */


char  matchar(soft,hard,type,set)

char  *soft;
int   hard;
int   type;
int   set;

{
   char  *hardexp="          ";
   char  *softexp="          ";
   char  *hardptr;
   char  *softptr;
   char   retval;
   
   switch (type)   {
      case (2):
         utoh (hard,hardexp);
         break;
      case (3):
         utoa (hard,hardexp);
         break;
      case (8):
         utob (hard,hardexp);
   }
   hardptr = strend(hardexp);
   strcpy (softexp,soft);
   softptr = strend(softexp);
   while (softptr >= softexp) {
      if (*softptr == '?')
         *softptr = *hardptr;
      softptr--;
      hardptr--;
   }
   switch (type)   {
      case (2):
         retval = (char) htoi(softexp);
         break;
      case (3):
         retval = (char) atoi(softexp);
         break;
      case (8):
         retval = (char) btoi(softexp);
   }
   return(retval);
}
/* end of matchar */


int  check (pattern,number,type)

char         *pattern;
unsigned    number;
int         type;

{
   char  *Query="          ";
   char  *Qptr;
   char  *Pptr;
   int   tflag = 1;

   switch (type)   {
      case (2):
         utoh (number,Query);
         break;
      case (3):
         utoa (number,Query);
         break;
      case (8):
         utob (number,Query);
   }
   Qptr = strend(Query);
   Pptr = strend(pattern);
   while ((Qptr >= Query) && tflag)   {
      if (*Pptr != '?')
		tflag=(*Pptr == *Qptr);
      Qptr--;
      Pptr--;
   }
   return (tflag);
}
/* end of match */

utoh (num,hex)

int   num;
char  *hex;

{
   char   *hexes = "0123456789abcdef";
   char   *ptr;

   ptr = hexes + (int) num/16;
   *hex++ = *ptr;
   num -= (*ptr - '0')*16;
   ptr = hexes + (int) num;
   *hex++ = *ptr;
   *hex = '\0';
}
/* end of utoh */

#include "Libs/utoa.c"
/* unsigned to ascii
utoa (num,ascii)
int	num;
char	*ascii;
{
	char	*asciis = "0123456789";
	char	*ptr;

	ptr = asciis + (int) num/100;
	*ascii++ = *ptr;
	num -= (*ptr - '0')*100;
	ptr = asciis + (int) num/10;
	*ascii++ = *ptr;
	num -= (*ptr - '0')*10;
	ptr = asciis + (int) num;
	*ascii++ = *ptr;
	*ascii = '\0';
}
end of utoa */

utob (num,bin)

int   num;
char  *bin;

{
   int curbin = 128;

   while (curbin)   {
      if (num >= curbin)   {
         num -= curbin;
         *bin++ = '1';
      } else {
         *bin++ = '0';
      }
      curbin = curbin/2;
   }
   *bin = '\0';
}
/* end of utob */

/* hex string to integer */
unsigned	htoi(hexstr)
char	*hexstr;
{
	char	*hexes="0123456789abcdef";
	char	*ptr;
	char	*hexptr;
	int	holder;
	int	RetVal=0;
	int	Placeholder=1;

	hexptr=strend(hexstr);
	while (--hexptr>=hexstr) {
		ptr=hexes;
		holder=0;
		while ((*ptr!= *hexptr) && *ptr) {
			++ptr;
			++holder;
		}
		RetVal+= (holder * Placeholder);
		Placeholder *= 16;
	}
	return RetVal;
}
/* end of htoi */

lower (strptr)

char  *strptr;

{
   for (;*strptr;*strptr++ = (char) tolower((int) *strptr));
}

char *strend(strptr)
char	*strptr;
{
	while (*strptr++);
	return --strptr;
}

int fputs(strptr,filptr)
char	*strptr;
FILE	*filptr;
{
	do {
		fputc(*strptr,filptr);
	} while (*++strptr);
}

ErrorOut(Why,Message)
int	Why;
char	*Message;
{
	printf ("Syntax: alter <char1> <char2> or alter <char1> <-string1>\n");
	printf ("Error: %s\n",Message);
	if (Why==Syntax) {
		printf ("Char1 and Char2 can use the ? wildcard if specified in binary,\n");
		printf ("   hexadecimal, or decimal.\n");
		printf ("Characters specified in binary must be 8 characters long.\n");
		printf ("Characters specified in hexadecimal must be 2 characters long.\n");
		printf ("Characters specified in decimal must be 3 characters long.\n");
		printf ("Strings can be of any length. Only characters may be replaced, but\n");
		printf ("   they may be replaced with a string.\n");
	}
}

