/* chop a line-oriented file into blocks of less than or equal to n K */
/* syntax: chop filename K */
/* Example: chop bigfile 60 /*
/*          will output _bigfile_ into bigfile.1, bigfile.2, etc. each
            one being 60k or less. */

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#define DEFMAXSIZE 10

char	*GetFileName();

main (argc,argv)
int	argc;
char	*argv[];
{
	FILE	*InPath; /* input file path */
	int	MaxSize=DEFMAXSIZE; /* maximum size of output files */
	int	StartPoint,EndPoint;
	int	CurrentFile;
	char	*OutFile;

/* check number of arguments */
	if (argc>4 || argc < 2) {
		DoHelp();
		exit();
	}

/* convert number, if exists, to int */
	if (argc>=3)
		if (!(MaxSize=atoi(argv[2])))
			if (argc==4) {
				DoHelp();
				exit();
			} else {
				MaxSize=DEFMAXSIZE;
				OutFile=argv[2];
			}
	if (argc==4)
		OutFile=argv[3];

	if (!(InPath=fopen(argv[1],"r"))) {
		printf ("Bad File Name: %s\n",argv[1]);
		exit();
	}

	if (!OutFile)
		OutFile=GetFileName(argv[1]);

	StartPoint=0;
	CurrentFile=1;
	EndPoint=GetEndPoint(StartPoint,MaxSize,InPath);
	if (OutputBlock(StartPoint,EndPoint,InPath,CurrentFile,OutFile))
		exit;
	while (!feof(InPath) && (EndPoint >= StartPoint)) {
		CurrentFile++;
		StartPoint=EndPoint+1;
		EndPoint=GetEndPoint(StartPoint,MaxSize,InPath);
		if (OutputBlock(StartPoint,EndPoint,InPath,CurrentFile,OutFile))
			exit;
	}
	close (InPath);
}

DoHelp()
{
	printf ("Syntax: chop filename [K [outfilebase]]\n");
	printf ("        where K is the number of K to chop filename into.\n");
}

char	*GetFileName(PathName)
char	*PathName;
{
	char	*FileName;

	FileName=strchr(PathName,'\0');
	while ((FileName != PathName) && (*(FileName-1) != '/'))
		FileName--;

	return (FileName);
}

int	GetEndPoint(Start,MaxSize,FilePath)
int	Start;
int	MaxSize;
FILE	*FilePath;
{
	int	EndPoint;

	EndPoint=Start+MaxSize*1024-1;
	fseek(FilePath,0,SEEK_END);
	if (EndPoint >= ftell(FilePath))
		return (ftell(FilePath)-1);

	fseek(FilePath,EndPoint,SEEK_SET);
	while ((fgetc(FilePath) != '\n') && (ftell(FilePath) > Start))
		fseek(FilePath,-2,SEEK_CUR);
	return(ftell(FilePath)-1);
}

OutputBlock(StartPoint,EndPoint,InPath,CurrentFile,InName)
int	StartPoint;
int	EndPoint;
FILE	*InPath;
int	CurrentFile;
char	*InName;
{
	char	*OutName;
	char	*Suffix="            ";
	char	*ProcID="                   ";
	int	pID;
	FILE	*OutPath;
	int	Counter;

	OutName=malloc(strlen(InName)+3);
	utoa(CurrentFile,Suffix);
	strcpy(OutName,InName);
/*	pID=getpid();
	utoa(pID,ProcID);
	strcat(OutName,".");
	strcat(OutName,ProcID); */
	strcat(OutName,"_");
	strcat(OutName,Suffix);

	/* write the file */
	fseek(InPath,StartPoint,SEEK_SET);

	if (!(OutPath=fopen(OutName,"w"))) {
		printf ("Error creating file %s\n",OutName);
		return (-1);
	}

	for (Counter=StartPoint;Counter<=EndPoint;Counter++)
		fputc(fgetc(InPath),OutPath);
	close (OutPath);
	free(OutName);
	fgetc(InPath);
	return (0);
}

#include "Libs/utoa.c"
