(*                                                                      *)
(*         Dangerous Journeys Character Generator                       *)
(*                   version 1.3                                        *)
(*                                                                      *)

(* original program by Robert Wright (rwright@umr.edu)    - 11/24/93 *)
(* First Mod  - Mike Phillips (msphil@birds.wm.edu)       - 12/4/93  *)
(* Second Mod - Robert Wright (rwright@umr.edu)           - 1-17-94  *)
(* Third Mod  - Slevin (bslevin@slate.Mines.Colorado.EDU) - 2-27-94  *)
(* Fourth Mod - Robert Wright (rwright@umr.edu)           - 2-27-94  *)
(* Fifth Mod  - Mike Phillips (msphil@birds.wm.edu)       - 4/13/94  *)

(* preliminary modifications, Mike Phillips (msphil@birds.wm.edu):
   12/4/93:
    * sorted die rolls in descending order for clarity
    * added error checking (keeping input in bounds)
    * fixed the "Press Any Key to Continue" handling to reflect message
   intended additions:
    * saving to file
	'We could just convert all of those screen writes to a
	file, (kill all gotoxy's) ' R.Wright
    * cleaning up screen, speeding up screen updates?
	'Does it really have to be faster' R.Wright
*)

(* More modifications by Robert Wright (rwright@umr.edu)
   1-17-94:
    * added age to the program
    * cleaned it up a bit (big overstatement) now easier to update
   intended additions :
    * character vocations (which means)
    * adding K/S areas (including deciding on Heka Amounts)
      (This is the next big thing to do)
      (Any help on how to do this is fine with me)
   *)

(* More Modifications by Slevin (bslevin@slate.Mines.Colorado.EDU)
   2-27-94:
    * re-roll of stats
    * allows you to roll or enter your stats
   *)

(* More modifications by Robert Wright (rwright@umr.edu)
   2-27-94:
    * improved character age procedure
       ( Now makes base character at age 25 )
    * prevents Spd and Pow to be greater than Cap
       ( Can happen with young kids )
   *)

(* tiny things changed, 4/13/94 by Mike Phillips (msphil@birds.wm.edu):
  * cleaned up final 'press any key to continue' message to be spaced
    correctly
  * added 're-roll' option for those real bastards who want that 'perfect'
    set of scores (like me, when creating an OP :-) )
[ rwright -- "Was added by Slevin first. I am using his code with my mods" ]
  * added Stats_To_File(), which saves the information to a straight ASCII
    text file that can then be edited however one wants -- makes this an
    even more useful program!
[ rwright -- "YEAH! I really didn't feel like doing that"                  ]
[            "Also thanks for the new variables in the code. I would have  ]
[             needed it soon."                                             ]
  intended additions :
    * different way to handle choosing scores (using arrow keys, and all)
      so that it's highlighted as one goes along.
[ rwright -- "Cool. That sounds good."                                     ]
*)

uses crt;

type
    die_index = 1..18;
    dice_array = array [die_index] of integer;
    dice_used  = array [die_index] of boolean;
    Category = record
	     Cap,Pow,Spd : integer;
	     end;
    PT = record
       Pnum,PMnum,PNnum : integer;
       M,N : category;
       WL,CL,Rl : integer;
       end;
    MT = record
       Mnum,MMnum,MRnum : integer;
       M,R : category;
       EL : integer;
       end;
    ST = record
       Snum,SMnum,SPnum : integer;
       M,P : category;
       EL : integer;
       end;

    OTS = record
	SEC,NW,BA,COH,DMI,Horse : longint;
	Joss,Attr,BM,BP,BS,child,child_die : longint;
	age : longint;
	atname : string[20];
        handed : string;
	end;

    Character = record
	      M : MT;
	      P : PT;
	      S : ST;
	      otherstuff : OTS;
	      end;


var
   used : dice_used;
   dice : dice_array;
   data : Character;
   reroll, toroll : char;

function die(num,pips : longint) : longint;
var d,i : longint;
begin
     d := 0;
     for i := 1 to num do
	d := d + random(pips) + 1;
     die := d;
end;


Procedure Sort_Dice;
(*
   Mike Phillips
   this procedure will sort the dice rolls stored in die[] in descending
   order, assisting the selection when choosing attributes.  Since it's a
   small array, the rather slow bubble-sort is easily implemented and not
   a drag in terms of execution time *)
	Procedure Swap (i1, i2 : integer);
	(* this local procedure swaps the values a and b *)
	var temp : integer;
	begin
	  temp := dice[i1];
	  dice[i1] := dice[i2];
	  dice[i2] := temp;
	end;
var i, j, minindex : integer;
begin
  for i := 1 to 17 do
    for j := 18 downto i+1 do
      if dice[j] > dice[i] then swap(i,j);
end; (* procedure Sort_Dice *)

Procedure Pause;
(* Mike Phillips
   This procedure will pause and wait for a keypress, eating all input that
   results.
*)
var inchar : char;
begin
  repeat
  until KeyPressed;
  while KeyPressed do
    inchar := ReadKey;
end; (* procedure Pause *)

procedure roll_dice;
var
   index : die_index;
begin
     randomize;
     for index := 1 to 18 do
	 begin
	 dice[index] := 10 + random(6) + random(6);
	 used[index] := false;
	 end;
end;

procedure enter_dice;
(* Slevin *)
var
   index : die_index;
   input : integer;
begin
     for index:=1 to 18 do
	 begin
	 write('Please enter a number (10-20): ');
	 readln(input);
	 if (input<=20) and (input>=10) then
	    begin
	    dice[index]:=input;
	    used[index] := false;
	    end
	 else
	    begin
	    index:=index-1;
	    writeln('That number in not in the accepted range');
	    writeln('Please Re-enter');
	    end;
	 end;
end;

procedure process;
begin
 with data.M do
      begin
      MMnum := M.Cap + M.Pow + M.Spd;
      MRnum := R.Cap + R.Pow + R.Spd;
      Mnum  := MMnum + MRnum;
      EL    := trunc (Mnum * 0.8);
      end;
 with data.P do
      begin
      PMnum := M.Cap + M.Pow + M.Spd;
      PNnum := N.Cap + N.Pow + N.Spd;
      Pnum  := PMnum + PNnum;
      WL    := trunc (Pnum * 0.75);
      CL    := trunc (Pnum * 0.9);
      RL    := trunc (Pnum * 0.1);
      end;
 with data.S do
      begin
      SMnum := M.Cap + M.Pow + M.Spd;
      SPnum := P.Cap + P.Pow + P.Spd;
      Snum  := SMnum + SPnum;
      EL    := trunc (Snum * 0.8);
      end;
      case data.M.Mnum of
	  0..36 : data.otherstuff.BM := 0;
	  36..53 : data.otherstuff.BM := 1;
	  54..75 : data.otherstuff.BM := 2;
	  76..100 : data.otherstuff.BM := 3;
	  101..130 : data.otherstuff.BM := 4;
	  end;
     case data.P.Pnum of
	  0..36 : data.otherstuff.BP := 0;
	  36..53 : data.otherstuff.BP := 1;
	  54..75 : data.otherstuff.BP := 2;
	  76..100 : data.otherstuff.BP := 3;
	  101..130 : data.otherstuff.BP := 4;
	  end;
     case data.S.Snum of
	  0..36 : data.otherstuff.BS := 0;
	  36..53 : data.otherstuff.BS := 1;
	  54..75 : data.otherstuff.BS := 2;
	  76..100 : data.otherstuff.BS := 3;
	  101..130 : data.otherstuff.BS := 4;
	  end;
     case data.otherstuff.attr of
	  1 : data.otherstuff.atname := 'Nasty';
	  2..3 : data.otherstuff.atname := 'Ugly';
	  4..7 : data.otherstuff.atname := 'Homely';
	  8..9 : data.otherstuff.atname := 'Plain';
	  10..12 : data.otherstuff.atname := 'Average';
	  13..15 : data.otherstuff.atname := 'Attractive/Cute';
	  16..17 : data.otherstuff.atname := 'Handsome/Pretty';
	  18 : data.otherstuff.atname := 'Striking';
	  19 : data.otherstuff.atname := 'Beautiful';
	  20 : data.otherstuff.atname := 'Stunning';
	  end;
 end;

procedure writenum;
var x,y : integer;
    c : die_index;
begin
     c := 1;
     for x := 1 to 6 do
	 for y := 1 to 3 do
	     begin
		  gotoxy( x*12 - 8 ,y+14 );
		  if used[c] then textcolor(green) else textcolor(white);
		  write(c,' : ',dice[c]);
		  inc(c);
	     end;
     textcolor(white);
end;

procedure topline;
begin
gotoxy(19,1);
Highvideo;
textcolor(Red);
write('Dangerous Journeys Character Creator v.1.3');
normvideo;
textcolor(white);
end;

procedure screen;
begin
     process;
     clrscr;
     topline;
     With data do begin

     gotoxy(5,2);
     write('Mental ',M.Mnum);

     gotoxy(30,2);
     write('Physical ',P.Pnum);

     gotoxy(55,2);
     write('Spiritual ',S.Snum);

     gotoxy(6,3);
     write('EL ',M.EL);

     gotoxy(31,3);
     write('WL ',P.WL);
     gotoxy(38,3);
     write('CL ',P.CL);
     gotoxy(45,3);
     write('RL ',P.RL);

     gotoxy(56,3);
     write('EL ',S.EL);

     gotoxy(5,5);
     write('Mnemonic ',M.MMnum);
     gotoxy(6,6);
     write('MMCap ',M.M.Cap);
     gotoxy(6,7);
     write('MMPow ',M.M.Pow);
     gotoxy(6,8);
     write('MMSpd ',M.M.Spd);
     gotoxy(5,10);
     write('Reasoning ',M.MRnum);
     gotoxy(6,11);
     write('MRCap ',M.R.Cap);
     gotoxy(6,12);
     write('MRPow ',M.R.Pow);
     gotoxy(6,13);
     write('MRSpd ',M.R.Spd);

     gotoxy(30,5);
     write('Muscular ',P.PMnum);
     gotoxy(31,6);
     write('PMCap ',P.M.Cap);
     gotoxy(31,7);
     write('PMPow ',P.M.Pow);
     gotoxy(31,8);
     write('PMSpd ',P.M.Spd);
     gotoxy(30,10);
     write('Neural ',P.PNnum);
     gotoxy(31,11);
     write('PNCap ',P.N.Cap);
     gotoxy(31,12);
     write('PNPow ',P.N.Pow);
     gotoxy(31,13);
     write('PNSpd ',P.N.Spd);

     gotoxy(55,5);
     write('Metaphysical ',S.SMnum);
     gotoxy(56,6);
     write('SMCap ',S.M.Cap);
     gotoxy(56,7);
     write('SMPow ',S.M.Pow);
     gotoxy(56,8);
     write('SMSpd ',S.M.Spd);
     gotoxy(55,10);
     write('Psychic ',S.SPnum);
     gotoxy(56,11);
     write('SPCap ',S.P.Cap);
     gotoxy(56,12);
     write('SPPow ',S.P.Pow);
     gotoxy(56,13);
     write('SPSpd ',S.P.Spd);
     end;
end;

procedure zero;
begin
 data.M.M.Cap := 0;
 data.M.M.Pow := 0;
 data.M.M.Spd := 0;
 data.M.R.Cap := 0;
 data.M.R.Pow := 0;
 data.M.R.Spd := 0;
 data.P.M.Cap := 0;
 data.P.M.Pow := 0;
 data.P.M.Spd := 0;
 data.P.N.Cap := 0;
 data.P.N.Pow := 0;
 data.P.N.Spd := 0;
 data.S.P.Cap := 0;
 data.S.P.Pow := 0;
 data.S.P.Spd := 0;
 data.S.M.Cap := 0;
 data.S.M.Pow := 0;
 data.S.M.Spd := 0;
end;

procedure pick;
var
   i : integer;
   choice : die_index;
begin

     repeat
     gotoxy(5,20);
     write('Choose a stat for MMCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.M.M.cap := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,21);
     write('Choose a stat for MMPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.M.M.cap);
     data.M.M.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for MMSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.M.M.cap);
     data.M.M.spd := dice[choice];
     used[choice]:=true;
     screen;
     writenum;


     repeat
     gotoxy(5,20);
     write('Choose a stat for MRCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.M.R.cap := dice[choice];
     used[choice]:=true;


     repeat
     gotoxy(5,21);
     write('Choose a stat for MRPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.M.R.cap);
     data.M.R.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for MRSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.M.R.cap);
     data.M.R.spd := dice[choice];
     used[choice]:=true;
     screen; writenum;


     repeat
     gotoxy(5,20);
     write('Choose a stat for PMCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.P.M.cap := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,21);
     write('Choose a stat for PMPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.P.M.cap);
     data.P.M.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for PMSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.P.M.cap);
     data.P.M.spd := dice[choice];
     used[choice]:=true;
     screen; writenum;


     repeat
     gotoxy(5,20);
     write('Choose a stat for PNCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.P.N.cap := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,21);
     write('Choose a stat for PNPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.P.N.cap);
     data.P.N.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for PNSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.P.N.cap);
     data.P.N.spd := dice[choice];
     used[choice]:=true;
     screen; writenum;


     repeat
     gotoxy(5,20);
     write('Choose a stat for SMCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.S.M.cap := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,21);
     write('Choose a stat for SMPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.S.M.cap);
     data.S.M.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for SMSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.S.M.cap);
     data.S.M.spd := dice[choice];
     used[choice]:=true;
     screen; writenum;


     repeat
     gotoxy(5,20);
     write('Choose a stat for SPCap : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]);
     data.S.P.cap := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,21);
     write('Choose a stat for SPPow : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.S.P.cap);
     data.S.P.pow := dice[choice];
     used[choice]:=true;

     repeat
     gotoxy(5,22);
     write('Choose a stat for SPSpd : ');
     readln(choice);
     until (not used[choice]) and (choice in [1..18]) and (dice[choice] <= data.S.P.cap);
     data.S.P.spd := dice[choice];
     used[choice]:=true;
     screen; writenum;
     end;
 
procedure Make_otherstuff;

begin
    case die(1,100) of
	 1..5   : data.otherstuff.SEC := 1;
	 6..10  : data.otherstuff.SEC := 2;
	 11..20 : data.otherstuff.SEC := 3;
	 21..30 : data.otherstuff.SEC := 4;
	 31..45 : data.otherstuff.SEC := 5;
	 46..70 : data.otherstuff.SEC := 6;
	 71..85 : data.otherstuff.SEC := 7;
	 86..95 : data.otherstuff.SEC := 8;
	 95..100 : data.otherstuff.SEC := 9;
	 end;
    gotoxy(1,15);
    data.otherstuff.horse := 0;
    case data.otherstuff.SEC of
	 1: begin
	    data.otherstuff.NW := ( die(3,3)+5 ) * 10;
	    data.otherstuff.BA := 0;
	    data.otherstuff.COH := ( die(5,10) + 10 );
	    data.otherstuff.DMI := 0;
	    end;
	 2: begin
	    data.otherstuff.NW := ( die(5,5)+3 ) * 20;
	    data.otherstuff.BA := 0;
	    data.otherstuff.COH := ( die(3,5) * 20 );
	    data.otherstuff.DMI := 0;
	    end;
	 3: begin
	    data.otherstuff.NW := ( die(3,3)+5 ) * 50;
	    data.otherstuff.BA := 0;
	    data.otherstuff.COH := ( die(5,3) * 50 );
	    data.otherstuff.DMI := 0;
	    end;
	 4: begin
	    data.otherstuff.NW := die(5,10)*200 ;
	    data.otherstuff.BA := 0;
	    data.otherstuff.COH := die(5,6)*20 ;
	    data.otherstuff.DMI := 0 ;
	    end;
	 5: begin
	    data.otherstuff.NW := (die(5,5)+5)*500 ;
	    data.otherstuff.BA := die(1,3)*1000;
	    data.otherstuff.COH := die(5,6)*50 ;
	    data.otherstuff.DMI := die(3,3)*10;
	    data.otherstuff.horse := die(4,3)*1000;
	    end;
	 6: begin
	    data.otherstuff.NW := (die(10,10)+10)*1000 ;
	    data.otherstuff.BA := die(3,3) * 2000;
	    data.otherstuff.COH := die(5,10) * 100;
	    data.otherstuff.DMI := die(3,6)*50;
	    data.otherstuff.horse := die(6,5)*1000;
	    end;
	 7: begin
	    data.otherstuff.NW := die(1,20)*10000 ;
	    data.otherstuff.BA := die(1,20)*1000;
	    data.otherstuff.COH := die(1,20)*500;
	    data.otherstuff.DMI := die(1,20)*100;
	    data.otherstuff.horse := die(6,5)*1000;
	    end;
	 8: begin
	    data.otherstuff.NW := die(3,20)*10000;
	    data.otherstuff.BA := die(3,20)*1000;
	    data.otherstuff.COH := die(3,10)*1000;
	    data.otherstuff.DMI := die(2,20)*100;
	    data.otherstuff.horse := die(6,5)*1000;
	    end;
	 9: begin
	    data.otherstuff.NW := die(5,20)*20000 ;
	    data.otherstuff.BA := die(5,10)*2000;
	    data.otherstuff.COH := die(5,10)*1000;
	    data.otherstuff.DMI := die(5,10)*200;
	    data.otherstuff.horse := die(6,5)*1000;
	    end;
	 end;
     data.otherstuff.attr := die(2,6)+8;
     case die(1,100) of
	  1..8 : data.otherstuff.Joss := 2;
	  9..16 : data.otherstuff.Joss := 3;
	  17..24 : data.otherstuff.Joss := 4;
	  25..31 : data.otherstuff.Joss := 5;
	  32..38 : data.otherstuff.Joss := 6;
	  39..46 : data.otherstuff.Joss := 7;
	  47..53 : data.otherstuff.Joss := 8;
	  54..61 : data.otherstuff.Joss := 9;
	  62..69 : data.otherstuff.Joss := 10;
	  70..76 : data.otherstuff.Joss := 11;
	  77..84 : data.otherstuff.Joss := 12;
	  85..92 : data.otherstuff.Joss := 13;
	  93..100 : data.otherstuff.Joss := 14;
	  end;
     case data.otherstuff.SEC of
	  1..3 : data.otherstuff.child := die(1,10);
	  4..6 : case die(1,100) of
		      1..15 : data.otherstuff.child := 1;
		      16..20 : data.otherstuff.child := 2;
		      21..45 : data.otherstuff.child := 3;
		      46..60 : data.otherstuff.child := 4;
		      61..75 : data.otherstuff.child := 5;
		      76..85 : data.otherstuff.child := 6;
		      86..95 : data.otherstuff.child := 7;
		      96..100 : data.otherstuff.child := 8;
		      end;
	  7..9 : case die(1,100) of
		      1..25 : data.otherstuff.child := 1;
		      26..50 : data.otherstuff.child := 2;
		      51..75 : data.otherstuff.child := 3;
		      76..90 : data.otherstuff.child := 4;
		      91..95 : data.otherstuff.child := 5;
		      96..98 : data.otherstuff.child := 6;
		      99..100 : data.otherstuff.child := 7;
		      end;
	  end;
     data.otherstuff.child_die := die(1,100);
     data.otherstuff.age := 25;
     case die(1,100) of
          1..75 : data.otherstuff.handed := 'Right-Handed';
          76..95 : data.otherstuff.handed := 'Left-Handed';
          96..100 : data.otherstuff.handed := 'Ambidextrous';
     end;
end;

procedure print_otherstuff;

begin
	  gotoxy(5,15);
	  write('SEC = ',data.otherstuff.SEC,'    Age =',data.otherstuff.age);
	  gotoxy(6,16);
	  write('Net Worth    = ',data.otherstuff.NW);
	  gotoxy(6,17);
	  write('Bank Account = ',data.otherstuff.BA);
	  gotoxy(6,18);
	  write('Cash on Hand = ',data.otherstuff.COH);
	  gotoxy(6,19);
	  write('DMI          = ',data.otherstuff.DMI);
	  gotoxy(6,20);
	  write('Horse        = ',data.otherstuff.Horse);

	  gotoxy(30,15);
	  write('Attractiveness = ',data.otherstuff.attr,' [',data.otherstuff.atname,']');
	  gotoxy(30,16);
	  write('Joss = ',data.otherstuff.joss);
          gotoxy(30,17);
          write(data.otherstuff.handed);

	  gotoxy(30,18);
	  write('Birth Rank = ',data.otherstuff.child);
          if data.otherstuff.child = 7 then
             begin
             gotoxy(31,19);
             case data.otherstuff.child_die of
                  1..50 : write('7th Child');
                  51..60 : write('7th Son or Daughter');
                  61..65 : write('7th Child of a 7th Child');
                  66..70 : write('7th Son or Daughter of a 7th Child');
                  71..75 : write('7th Child of a 7th Son or Daughter');
                  76..80 : write('7th Son/Daughter of a 7th Daughter/Son');
                  81..85 : write('7th Son/Daughter of a 7th Son/Daughter');
                  86..90 : write('7th Child of 7th Child Parents');
                  91..94 : write('7th Son/Daughter of 7th Child Parents');
                  95..97 : write('7th S/D of 7th Child & 7th D/S Parents');
                  98..99 : write('7th S/D of 7th Child & 7th S/D Parents');
                  100    : write('7th S/D of 7th S/D Parents');
                  end;
             end;

	  gotoxy(30,20);
	  write('Bonus Mental Skills = ',data.otherstuff.BM);
	  gotoxy(30,21);
	  write('Bonus Physical Skills = ',data.otherstuff.BP);
	  gotoxy(30,22);
	  write('Bonus Spiritual Skills = ',data.otherstuff.BS);
    end;

procedure center( str : string );
    var i : integer;
    begin
	 gotoxy( (80 - length(str)) div 2 , wherey);
	 write(str);
    end;

procedure endscreen;

var inchar : char; (* used for ReadKey *)

begin
     gotoxy(1,3);
     center('Dangerous Journeys Character Creator');
     gotoxy(1,5);
     center('By Robert Wright');
     gotoxy(1,6);
     center('[rwright@umr.edu]');
     gotoxy(1,9);
     writeln('             If you recieve this program drop me line. We can exchange');
     writeln('        Mythus game adventures. This program is absolutely freeware.');
     writeln('        Any modification to this program is fine with me. Send the');
     writeln('        new version to me. Have fun and Happy Mything.');
     gotoxy(1,19);
     writeln(' Dangerous Journeys and all the other possible Mythus stuff');
     writeln('   is copyright of Omega Helios Limited. None of it is used');
     writeln('   with permission. Oh well.');
     delay(5000);
     writeln;
     writeln('Press a key to Continue');
     Pause;
end;

procedure Opener;
begin
     gotoxy(1,3);
     center('Dangerous Journeys Character Creator V 1.3');
     gotoxy(1,5);
     center('By Robert Wright');
     gotoxy(1,6);
     center('[rwright@umr.edu]');
     gotoxy(1,10);
     center('For use with the Dangerous Journeys Role-Playing Game');
     gotoxy(1,11);
     center('By Gary Gygax and Others');
     gotoxy(1,12);
     center('Buy now or never see it again');
     gotoxy(1,15);
     center('Dedicated to all of those who helped produce DJ at GDW');
     gotoxy(1,19);
     center('And dedicated against TSR and their lawyers');
     writeln;
     delay(2500);
     gotoxy(1,23);
     center('Press a key to continue');
     pause;
     clrscr;
end;


procedure Age_character;
var response : char;
    age : integer;
begin
     repeat
	   gotoxy(5,23);
	   write('Do you wish change the age of this character (y/n)? ');
	   read(response);
     until ( response = 'y') or (response = 'n' );
     if response = 'y' then
	begin
	     gotoxy(5,23);
	     write('                                                        ');
	     gotoxy(5,23);
	     write('What age do you want the character to be? ');
	     readln(data.otherstuff.age);
	     age := data.otherstuff.age;
	     gotoxy(5,23);
	     write('                                                        ');
        end
     else
         begin
              age := 25;
              data.otherstuff.age := 25;
         end;



     with data do
          begin
	  if age <= 15 then
             begin
	          inc(otherstuff.attr,3);
		  dec(M.M.Cap,2);
		  dec(M.M.Pow,2);
		  dec(M.M.Spd,2);
		  dec(M.R.Cap,2);
		  dec(M.R.Pow,2);
		  dec(M.R.Spd,2);
		  inc(P.M.Cap);
		  inc(P.N.Cap);
		  dec(P.M.pow,4);
		  dec(P.N.pow,4);
		  inc(P.M.Spd,4);
		  inc(P.N.spd,4);
		  dec(S.M.cap,4);
		  dec(S.M.pow,4);
		  dec(S.M.spd,4);
		  dec(S.P.cap,4);
		  dec(S.P.pow,4);
		  dec(S.P.spd,4);
		  with otherstuff do
		       begin
		       DMI := trunc(DMI/8);
		       COH := trunc(COH/8);
		       NW  := trunc(NW/8);
		       BA  := trunc(BA/8);
		       end
	     end
	  else if age <= 19 then
               begin
	            inc(otherstuff.attr,2);
		    inc(P.M.Cap,3);
		    inc(P.N.Cap,3);
		    inc(P.M.Spd,2);
		    inc(P.N.spd,2);
		    dec(S.M.cap,2);
		    dec(S.M.pow,2);
		    dec(S.M.spd,2);
		    dec(S.P.cap,2);
		    dec(S.P.pow,2);
		    dec(S.P.spd,2);
		    with otherstuff do
		         begin
			      DMI := trunc(DMI/4);
			      COH := trunc(COH/4);
			      NW  := trunc(NW/4);
			      BA  := trunc(BA/4);
			 end;
	       end
	  else if age <= 24 then
               begin
	            inc(otherstuff.attr,1);
		    inc(P.M.Cap,2);
		    inc(P.N.Cap,2);
		    inc(P.M.Spd,1);
		    inc(P.N.spd,1);
		    with otherstuff do
		         begin
			      DMI := trunc(DMI/2);
			      COH := trunc(COH/2);
			      NW  := trunc(NW/2);
			      BA  := trunc(BA/2);
			 end;
	       end
	  else if age <= 35 then
               begin
	            inc(P.M.Cap);
		    inc(P.N.Cap);
	       end
	  else if age <= 40 then
               begin
	       with otherstuff do
	            begin
		         DMI := DMI*2;
			 COH := COH*2;
			 NW  := NW*2;
			 BA  := BA*2;
		    end;
	       end
	  else if age <= 50 then
               begin
	       with otherstuff do
	            case SEC of
		         1..6 :
                              begin
			           DMI := DMI*3;
			           COH := COH*3;
			           NW  := NW*3;
			           BA  := BA*3;
			      end;
			 7..9 :
                              begin
			           DMI := DMI*4;
				   COH := COH*4;
				   NW  := NW*4;
				   BA  := BA*4;
			      end;
	            end;
	       end
	  else if age <= 60 then
               begin
	       with otherstuff do
	            case SEC of
		         1..6 :
                              begin
			           DMI := DMI*4;
			           COH := COH*4;
				   NW  := NW*4;
				   BA  := BA*4;
			      end;
			 7..9 :
                              begin
			           DMI := DMI*8;
				   COH := COH*8;
				   NW  := NW*8;
				   BA  := BA*8;
			      end;
		    end;
	       end
	  else with otherstuff do
	       case SEC of
	            1..6 :
                         begin
		              DMI := DMI*5;
			      COH := COH*5;
			      NW  := NW*5;
			      BA  := BA*5;
			 end;
		    7..9 :
                         begin
			      DMI := DMI*16;
			      COH := COH*16;
			      NW  := NW*16;
			      BA  := BA*16;
			 end;
	       end;

	  if age >= 41 then
             begin
	          dec(otherstuff.attr);
	          dec(P.M.Spd);
		  dec(P.N.Spd);
	     end;
	  if age >= 46 then
             begin
	          dec(otherstuff.attr);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
	     end;
	  if age >= 51 then
             begin
	          dec(otherstuff.attr);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
	     end;
	  if age >= 56 then
             begin
	          dec(otherstuff.attr);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
		  inc(S.P.pow);
		  inc(S.M.pow);
	     end;
	  if age >= 61 then
             begin
	          dec(otherstuff.attr);
		  dec(M.M.spd);
		  dec(M.R.Spd);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
		  inc(S.P.pow);
		  inc(S.M.pow);
	     end;
	  if age >= 66 then
             begin
	          dec(otherstuff.attr);
		  dec(M.M.Pow);
		  dec(M.R.Pow);
		  dec(M.M.spd);
		  dec(M.R.Spd);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
		  inc(S.P.pow);
		  inc(S.M.pow);
		  inc(S.P.Spd);
		  inc(S.M.Spd);
	     end;
	  if age >= 71 then
             begin
	          dec(otherstuff.attr);
		  dec(M.M.Cap);
		  dec(M.R.Cap);
		  dec(M.M.Pow);
	          dec(M.R.Pow);
		  dec(M.M.spd);
		  dec(M.R.Spd);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap);
		  inc(S.M.Cap);
		  inc(S.P.pow);
		  inc(S.M.pow);
		  inc(S.P.Spd);
		  inc(S.M.Spd);
	     end;
	  if age >= 76 then
             begin
	          dec(otherstuff.attr);
		  dec(M.M.Cap);
		  dec(M.R.Cap);
		  dec(M.M.Pow);
		  dec(M.R.Pow);
		  dec(M.M.spd);
		  dec(M.R.Spd);
		  dec(P.M.Cap);
		  dec(P.N.Cap);
		  dec(P.M.Pow);
		  dec(P.N.Pow);
		  dec(P.M.Spd);
		  dec(P.N.Spd);
		  inc(S.P.Cap,2);
		  inc(S.M.Cap,2);
		  inc(S.P.pow);
		  inc(S.M.pow);
		  inc(S.P.Spd);
		  inc(S.M.Spd);
	     end;
	  end;
     with data do
          begin
               if M.M.Spd > M.M.Cap then M.M.Spd := M.M.Cap;
               if M.R.Spd > M.R.Cap then M.R.Spd := M.R.Cap;
               if P.M.Spd > P.M.Cap then P.M.Spd := P.M.Cap;
               if P.N.Spd > P.N.Cap then P.N.Spd := P.N.Cap;
               if S.M.Spd > S.M.Cap then S.M.Spd := S.M.Cap;
               if S.P.Spd > S.P.Cap then S.P.Spd := S.P.Cap;

               if M.M.Pow > M.M.Cap then M.M.Pow := M.M.Cap;
               if M.R.Pow > M.R.Cap then M.R.Pow := M.R.Cap;
               if P.M.Pow > P.M.Cap then P.M.Pow := P.M.Cap;
               if P.N.Pow > P.N.Cap then P.N.Pow := P.N.Cap;
               if S.M.Pow > S.M.Cap then S.M.Pow := S.M.Cap;
               if S.P.Pow > S.P.Cap then S.P.Pow := S.P.Cap;
          end;
end;

procedure Dice_or_Roll;
(* Slevin & Robert Wright *)
begin
  write('Do you want to [R]oll or [E]nter your traits? ');
  readln(toroll);
  textcolor(white);
  if (toroll = 'E') or (toroll = 'e') then
     begin
          enter_dice;
          screen;
          writenum;
     end
  else
      repeat
            roll_dice;
            Sort_Dice;
            zero;
            screen; writenum;
            gotoxy(5, 20);
            write('Roll Again? ');
	    reroll:=readkey;
      until (reroll='n') or (reroll='N');
end;


Procedure Stats_To_File(filename : string);
(* Mike Phillips (4/13/94)
   this saves the TRAITS, CATEGORIES, ATTRIBUTES to file, formatted as
   it is on the screen *)
var t : text;
begin
  assign(t, filename);
  rewrite(t);
  with data do
    begin
      write(t,  'Mental: ', M.Mnum:3, '              ');
      write(t,  'Physical: ', P.Pnum:3, '            ');
      writeln(t,'Spiritual: ', S.Snum:3);
      write(t,  ' EL: ', M.EL:2, '                  ');
      write(t,  ' WL: ', P.WL:2, ' CL: ', P.CL:3, ' RL: ',P.RL:2, '   ');
      writeln(t,' EL: ', S.EL:2);
      writeln(t);
      write(t,  'Mnemonic: ', M.MMnum:2, '             ');
      write(t,  'Muscular: ', P.PMnum:2, '             ');
      writeln(t,'Metaphysical: ', S.SMnum:2);
      write(t,  ' MMCap: ', M.M.Cap, '               ');
      write(t,  ' PMCap: ', P.M.Cap, '               ');
      writeln(t,' SMCap: ', S.M.Cap);
      write(t,  ' MMPow: ', M.M.Pow, '               ');
      write(t,  ' PMPow: ', P.M.Pow, '               ');
      writeln(t,' SMPow: ', S.M.Pow);
      write(t,  ' MMSpd: ', M.M.Spd, '               ');
      write(t,  ' PMSpd: ', P.M.Spd, '               ');
      writeln(t,' SMSpd: ', S.M.Spd);
      writeln(t);
      write(t,  'Reasoning: ', M.MMnum:2, '            ');
      write(t,  'Neural: ', P.PMnum:2, '               ');
      writeln(t,'Psychic: ', S.SMnum:2);
      write(t,  ' MRCap: ', M.R.Cap, '               ');
      write(t,  ' PNCap: ', P.N.Cap, '               ');
      writeln(t,' SPCap: ', S.P.Cap);
      write(t,  ' MRPow: ', M.R.Pow, '               ');
      write(t,  ' PNPow: ', P.N.Pow, '               ');
      writeln(t,' SPPow: ', S.P.Pow);
      write(t,  ' MRSpd: ', M.R.Spd, '               ');
      write(t,  ' PNSpd: ', P.N.Spd, '               ');
      writeln(t,' SPSpd: ', S.P.Spd);
      writeln(t);
      with otherstuff do
        begin
          write(t,  'SEC = ', SEC:1, '                  ');
          writeln(t,'Attractiveness = ', attr: 1, ' [', atname, ']');
          write(t,  ' Net Worth    = ', NW:8, ' ');
          writeln(t,'Joss = ', joss:1);
          write(t,  ' Bank Account = ', BA:8, ' ');
          writeln(t, handed);
          write(t,  ' Cash on Hand = ', COH:8, ' ');
          writeln(t,'Birth Rank = ', child:1);
          write(t,  ' DMI          = ', DMI:8);
          if child = 7 then
            begin
             case child_die of
               1..50 :  writeln(t, '7th Child');
               51..60 : writeln(t, '7th Son or Daughter');
               61..65 : writeln(t, '7th Child of a 7th Child');
               66..70 : writeln(t, '7th Son or Daughter of a 7th Child');
               71..75 : writeln(t, '7th Child of a 7th Son or Daughter');
               76..80 : writeln(t, '7th Son/Daughter of a 7th Daughter/Son');
               81..85 : writeln(t, '7th Son/Daughter of a 7th Son/Daughter');
               86..90 : writeln(t, '7th Child of 7th Child Parents');
               91..94 : writeln(t, '7th Son/Daughter of 7th Child Parents');
               95..97 : writeln(t, '7th S/D of 7th Child & 7th D/S Parents');
               98..99 : writeln(t, '7th S/D of 7th Child & 7th S/D Parents');
               100    : writeln(t, '7th S/D of 7th S/D Parents');
              end;
            end
            else writeln(t);
          write(t,  ' Horse        = ', Horse:8, ' ');
          writeln(t,'Bonus Mental Skills    = ', BM:1);
          write(t,  '                         ');
          writeln(t,'Bonus Physical Skills  = ', BP:1);
          write(t,  '                         ');
          writeln(t,'Bonus Spiritual Skills = ', BS:1);
        end;
    end;
  close(t);
end;

procedure print;
var
   inch : char;
   s : string;
begin

     gotoxy(5,24);
     write('Save to file? (Y/N) ');
     repeat
       inch := upcase(readkey);
     until inch in ['Y', 'N'];
     if inch = 'Y' then
       begin
         GotoXY(5,24); write('Save to what file? ');
         readln(s);
         Stats_To_File(s);
       end;
end;

begin
     clrscr;
     textcolor(white);
     Opener;
     Dice_or_Roll;
     pick;
     make_otherstuff;
     age_character;
     screen;
     print_otherstuff;
     print;
     gotoxy(5,24);
     writeln('PRESS ANY KEY TO EXIT PROGRAM');
     gotoxy(5,24);
     Pause;
     clrscr;
     endscreen;
     normvideo;
end.


