BEGIN    { 
           FS = "\t";
	   linesperpage = 40;
	   lines = 0; lasthline = -1;
	 }
/^[%#]/  { next; }
         { 
	   if (lines % 5 == 0)
	     {
	       if (lines % linesperpage == 0)
		 {
		   if (lines > 0)
		     {
		       printf("\\hline\n\\end{tabular}\n\n");
		     }
		   printf("\\begin{tabular}{|lcc|rr|rr|}\n\\hline\n");
		   printf("Name & Class. & Faces & Lon. & Lat. & Can. & Dead");
		   printf(" \\\\\n\\hline\n");
		 }
	       else
		 {
		   if (lasthline != lines)
		     {
		       printf("\\hline\n");
		       lasthline = lines;
		     }
		 }
	     }
	 }
/->/     { 
           printf("\\multicolumn{3}{|l|}{%s cf.\\ %s} & & & & \\\\\n",
		  $1, $3);
	   lines++;
	   next;
	 }
/^\$/    { next; }
         { class[$1] = $2;
	   defln[$1] = NR;
	   countcanals($1,$6);
	   printf("%s & %s & %s & %s & %s & %s & %s \\\\\n",
		  $1, $2, $3, $4, $5, canaln_l[$1], canaln_d[$1]);
	   lines++;
	   next;
	 }
END      { 
           printf("\\hline\n\\end{tabular}\n\n");
	 }

function countcanals(city,txt, living,dead,arr) {
    if (split(txt,arr,"&") == 2)
      {
	living = arr[1];
	dead   = arr[2];
	canaln_l[city] = split(living,arr,",");
	if (canaln_l[city] == 0)
	  {
	    canaln_l[city] = "";
	  }
	canaln_d[city] = split(dead,arr,",");
	if (canaln_d[city] == 0)
	  {
	    canaln_d[city] = "";
	  }
      }
  }
