BEGIN    { FS = "\t"; cosf = cos(0.4); sinf = sin(0.4); }
/^[%#]/  { next; }
/^\$/    { class[$1] = "$";
	   defln[$1] = NR;
	   longi[$1] = txt2longi($3);
	   latit[$1] = txt2latit($4);
	   next;
	 }
         { if ($2 != "->")
	     { 
	       class[$1] = $2;
	       defln[$1] = NR;
	       longi[$1] = txt2longi($4);
	       latit[$1] = txt2latit($5);
	       txt2canals($1,$6);
	     }
	 }
END      { printf(".PS\n");
	   for (i = -80; i < 81; i += 20)
	     {
	       meridian(-180,i,180,i);
	       cityname(-180,i,latit2txt(i));
	     }
	   for (i = -180; i < 181; i += 20)
	     {
	       meridian(i,-80,i,80);
	       cityname(i,80,longi2txt(i));
	     }
           for (i in class)
	     {
	       if (class[i] == "A")
		 {
		   areaname(longi[i],latit[i],i);
		 }
	       else if (class[i] == "C")
		 {
		   plotcity(longi[i], latit[i]);
		   cityname(longi[i],latit[i],i);
		   for (j = 1; j <= canaln_l[i]; j++)
		     {
		       c = canals_l[i SUBSEP j];
		       if (! (check_reverse_l(i,c)))
			 {
			   printf("Canal from %s to %s has no reverse.\n",
				  i, c) >> "/dev/stderr";
			 }
		       else if (c == "N")
			 {
			   drawliving(longi[i], latit[i], longi[i], 80);
			 }
		       else if (c == "S")
			 {
			   drawliving(longi[i], latit[i], longi[i], -80);
			 }
		       else if (! (c in class))
			 {
			   printf("Unknown place: %s in %d\n",
				  c, defln[i]) >> "/dev/stderr";
			 }   
		       else
			 {
			   drawliving(longi[i], latit[i], longi[c], latit[c]);
			 }
		     }
		   for (j = 1; j <= canaln_d[i]; j++)
		     {
		       c = canals_d[i SUBSEP j];
		       if (! (check_reverse_d(i,c)))
			 {
			   printf("Canal from %s to %s has no reverse.\n",
				  i, c) >> "/dev/stderr";
			 }
		       else if (c == "N")
			 {
			   drawdead(longi[i], latit[i], longi[i], 80);
			 }
		       else if (c == "S")
			 {
			   drawdead(longi[i], latit[i], longi[i], -80);
			 }
		       else if (! (c in class))
			 {
			   printf("Unknown place: %s in %d\n",
				  c, defln[i]) >> "/dev/stderr";
			 }   
		       else
			 {
			   drawdead(longi[i], latit[i], longi[c], latit[c]);
			 }
		     }
		 }
	     }
	   printf(".PE\n");
	 }

function txt2longi(txt, l) {
    l = length(txt);
    if (substr(txt,l,1) == "w")
      {
	return -(substr(txt,1,l-1));
      }
    else
      {
	return substr(txt,1,l-1);
      }
  }

function txt2latit(txt, l) {
    l = length(txt);
    if (substr(txt,l,1) == "s")
      {
	return -(substr(txt,1,l-1));
      }
    else
      {
	return substr(txt,1,l-1);
      }
  }

function longi2txt(longitude) {
    if (longitude < 0)
      {
	return -longitude "w";
      }
    else if (longitude > 0)
      {
	return longitude "e";
      }
    else
      {
	return 0;
      }
  }

function latit2txt(latitude) {
    if (latitude < 0)
      {
	return -latitude "s";
      }
    else if (latitude > 0)
      {
	return latitude "n";
      }
    else
      {
	return 0;
      }
  }

function txt2canals(city,txt, living,dead,arr) {
    if (split(txt,arr,"&") == 2)
      {
	living = arr[1];
	dead   = arr[2];
	canaln_l[city] = split(living,arr,",");
	for (i = 1; i <= canaln_l[city]; i++)
	  {
	    canals_l[city SUBSEP i] = arr[i];
	  }
	canaln_d[city] = split(dead,arr,",");
	for (i = 1; i <= canaln_d[city]; i++)
	  {
	    canals_d[city SUBSEP i] = arr[i];
	  }
      }
  }

function check_reverse_l(from,to, i,n) {
    if (to == "N" || to == "S" || class[to] == "$")
      {
	return 1;
      }
    if (class[to] != "C")
      {
	printf("Is of class %s: %s in canal def of %s\n", 
	       class[to], to, from) >> "/dev/stderr";
	return 0;
      }
    n = canaln_l[to];
    for (i = 1; i <= n; i++)
      {
	if (from == canals_l[to SUBSEP i])
	  {
	    return 1;
	  }
      }
    return 0;
  }
    
function check_reverse_d(from,to, i,n) {
    if (to == "N" || to == "S" || class[to] == "$")
      {
	return 1;
      }
    if (class[to] != "C")
      {
	printf("Is of class %s: %s in canal def of %s\n", 
	       class[to], to, from) >> "/dev/stderr";
	return 0;
      }
    n = canaln_d[to];
    for (i = 1; i <= n; i++)
      {
	if (from == canals_d[to SUBSEP i])
	  {
	    return 1;
	  }
      }
    return 0;
  }
    
function meridian(flo,fla,tlo,tla) {
    printf("line dotted from %f,%f to %f,%f\n",
	   xformx(flo,fla), xformy(flo,fla), xformx(tlo,tla), xformy(tlo,tla));
  }
	   
function areaname(lo,la,text) {
    printf("\"{\\sc %s}\" at %f,%f\n", text, xformx(lo,la), xformy(lo,la));
  }

function cityname(lo,la,text) {
    printf("\"{\\tiny %s}\" at %f,%f above\n",
	   text, xformx(lo+2,la+2), xformy(lo+2,la+2));
  }

function plotcity(lo,la) {
    printf("box fill ht 0.05 wid 0.05 at %f,%f\n",
	   xformx(lo,la), xformy(lo,la));
  }

function drawliving(flo,fla,tlo,tla,  m) {
#    printf("drawliving(%f,%f,%f,%f)\n", flo,fla,tlo,tla) >> "/dev/stderr";
    if (tlo < flo)
      {
#	printf("reversing...\n") >> "/dev/stderr";
	drawliving(tlo,tla,flo,fla);
      }
    else
      {
	if (tlo - flo > 180)
	  {
#	    printf("wraparound...\n") >> "/dev/stderr";
	    m = fla + (tla - fla) * (180 - flo) / (360 + tlo - flo);
	    drawliving(-180,m,flo,fla);
	    drawliving(tlo,tla,180,m);
	  }
	else
	  {
#	    printf("written...\n") >> "/dev/stderr";
	    printf("line from %f,%f to %f,%f\n",
		   xformx(flo,fla), xformy(flo,fla),
		   xformx(tlo,tla), xformy(tlo,tla));
	  }
      }
  }
     
function drawdead(flo,fla,tlo,tla,  m) {
#    printf("drawdead(%f,%f,%f,%f)\n", flo,fla,tlo,tla) >> "/dev/stderr";
    if (tlo < flo)
      {
#	printf("reversing...\n") >> "/dev/stderr";
	drawdead(tlo,tla,flo,fla);
      }
    else
      {
	if (tlo - flo > 180)
	  {
#	    printf("wraparound...\n") >> "/dev/stderr";
	    m = fla + (tla - fla) * (180 - flo) / (360 + tlo - flo);
	    drawdead(-180,m,flo,fla);
	    drawdead(tlo,tla,180,m);
	  }
	else
	  {
#	    printf("written...\n") >> "/dev/stderr";
	    printf("line dashed from %f,%f to %f,%f\n",
		   xformx(flo,fla), xformy(flo,fla),
		   xformx(tlo,tla), xformy(tlo,tla));
	  }
      }
  }

#function xformx(longitude, latitude) {
#    while (longitude >  180) longitude -= 360;
#    while (longitude < -180) longitude += 360;
#    return ((80 + latitude) / 160) * 10 / 2.54;
#  }

#function xformy(longitude, latitude) {
#    while (longitude >  180) longitude -= 360;
#    while (longitude < -180) longitude += 360;
#    return ((180 + longitude) / 360) * 20 / 2.54;
#  }

function xformx(longitude, latitude) {
    while (longitude >  180) longitude -= 360;
    while (longitude < -180) longitude += 360;
    x = fnlatitude(latitude) * cosf + longitude * sinf;
    return ((80 + x) / 160) * 10 / 2.54;
  }

function xformy(longitude, latitude) {
    while (longitude >  180) longitude -= 360;
    while (longitude < -180) longitude += 360;
    y = fnlatitude(latitude) * sinf - longitude * cosf;
    return ((180 + y) / 360) * 20 / 2.54;
  }

#function fnlatitude(lat) {
#    return lat;
#  }

function fnlatitude(lat, x) {
    x = lat / 80; x = x * x;
    return lat * (1.5 - 0.5 * x);
  }

